# Prompt Creation Guide

This guide explains how to add new prompts to the `prompts.json` file.

## Prompt JSON Structure

To add a new prompt, you must add a new object to the `prompts` array in `prompts.json`.

### Required Fields

| Field | Type | Description |
| :--- | :--- | :--- |
| `id` | `UUID` | A unique identifier (UUID v4). **Must be unique.** |
| `title` | `String` | The display title of the prompt. |
| `description` | `String` | A short explanation of what the prompt does. |
| `template` | `String` | The actual prompt text with variables (see Syntax below). |
| `categories` | `[UUID]` | Array of Category UUIDs. **Must match IDs in `Data/data.json`.** |
| `tags` | `[String]` | Array of keywords (e.g., "text", "image", "midjourney"). **Must match tags in `Data/data.json`.** |
| `created` | `String` | Creation date in `YYYY-MM-DD` format. |
| `updated` | `String` | Last update date in `YYYY-MM-DD` format. |
| `active` | `Boolean` | Set to `true` to enable. |
| `hot` | `Boolean` | Set to `true` if it's a popular/featured prompt. |

### Example Entry

```json
{
  "id": "550e8400-e29b-41d4-a716-446655440000",
  "title": "My New Prompt",
  "description": "This is a description of what the prompt does.",
  "template": "Write a story about {{Topic}} in a {{Style:[tones]}} style.",
  "categories": [
    "79FB5A77-659E-40CC-967E-B3FE38E66A26" 
  ],
  "tags": [
    "text",
    "creative"
  ],
  "created": "2024-01-01",
  "updated": "2024-01-01",
  "active": true,
  "hot": false
}
```

> [!IMPORTANT]
> **UUIDs are Mandatory**: Both the prompt `id` and the `categories` array must use valid UUIDs. 
> Do not use string names for categories. Look up the correct UUID in `PUCO/Data/data.json`.

## Variable Syntax

Variables are dynamic placeholders that users fill out. They use the `{{Label:Value}}` syntax.

### Separator
- Use a colon `:` to separate the label from the default value or options.
- Example: `{{Tone:Diplomatic}}`

### Variable Types (Inferred)

The system automatically detects the input type based on the value you provide:

1.  **Multiline Text** (Default)
    -   Usage: Simple text placeholders.
    -   Syntax: `{{Label}}` or `{{Label:Default Text}}`
    -   Example: `{{Topic}}` or `{{Topic:climate change}}`

2.  **ComboBox (Editable Dropdown)**
    -   Usage: Provide a list of options. Users can select one or type their own.
    -   Syntax: `{{Label:Option1, Option2}}` OR `{{Label:[global_variable]}}`
    -   Example: `{{Tone:Formal, Casual}}` or `{{Tone:[tones]}}`

3.  **Number**
    -   Usage: Numeric input.
    -   Syntax: `{{Label:DefaultNumber}}`
    -   Logic: Inferred if the default value is a valid number.
    -   Example: `{{Count:10}}` or `{{Price:9.99}}`

4.  **Range (Slider)**
    -   Usage: A slider for selecting values within a range.
    -   Syntax: `{{Label:Min-Max}}`
    -   Logic: Inferred if the value follows the `number-number` pattern.
    -   Example: `{{Word Count:50-200}}`

5.  **Date Picker**
    -   Usage: Date selection.
    -   Syntax: `{{Label:YYYY-MM-DD}}`
    -   Logic: Inferred if the value matches the ISO8601 date format.
    -   Example: `{{Deadline:2026-01-01}}`

## Global Variables

You can define reusable lists in the `variables` section of `data.json` and reference them using brackets.

```json
"variables": {
  "tones": ["Professional", "Casual", "Witty"]
}
```

Reference in a prompt: `{{Tone:[tones]}}`
